/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.globalsetting.service.impl;

import com.tp_link.eap.configuration.Configuration;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.bean.GlobalStatInfo;
import com.tp_link.eap.domain.eapsetting.DaylightSaving;
import com.tp_link.eap.domain.eapsetting.Led;
import com.tp_link.eap.domain.eapsetting.LogConfig;
import com.tp_link.eap.domain.eapsetting.MacFilterGlobal;
import com.tp_link.eap.domain.eapsetting.ManagementVlanConfig;
import com.tp_link.eap.domain.eapsetting.PortalConfig;
import com.tp_link.eap.domain.eapsetting.QosConfig;
import com.tp_link.eap.domain.eapsetting.SchedulerGlobal;
import com.tp_link.eap.domain.eapsetting.SshConfig;
import com.tp_link.eap.domain.eapsetting.TimeConfig;
import com.tp_link.eap.domain.eapsetting.UserAccountConfig;
import com.tp_link.eap.domain.eapsetting.WirelessAdvConfig;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.globalsetting.BackupInitData;
import com.tp_link.eap.domain.globalsetting.BandSteering;
import com.tp_link.eap.domain.globalsetting.GlobalEnable;
import com.tp_link.eap.domain.globalsetting.HistoryRetentionSetting;
import com.tp_link.eap.domain.globalsetting.LogSetting;
import com.tp_link.eap.domain.globalsetting.ManagementVlanSetting;
import com.tp_link.eap.domain.globalsetting.PortalSetting;
import com.tp_link.eap.domain.globalsetting.QosSetting;
import com.tp_link.eap.domain.globalsetting.SshSetting;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.globalsetting.TimeSetting;
import com.tp_link.eap.domain.globalsetting.UserAccountSetting;
import com.tp_link.eap.domain.globalsetting.Wireless;
import com.tp_link.eap.domain.mesh.document.MeshSetting;
import com.tp_link.eap.domain.meta.Data;
import com.tp_link.eap.domain.roaming.document.RoamingSetting;
import com.tp_link.eap.domain.roaming.json.IssuedRoamingInfo;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.f.c;
import com.tp_link.eap.monitor.globalsetting.model.AboutInfo;
import com.tp_link.eap.monitor.globalsetting.model.GlobalEnableInfo;
import com.tp_link.eap.monitor.globalsetting.model.LogSettingInfo;
import com.tp_link.eap.monitor.globalsetting.model.MoreSettingsInfo;
import com.tp_link.eap.monitor.globalsetting.model.QosSettingInfo;
import com.tp_link.eap.monitor.globalsetting.model.UserAccountInfo;
import com.tp_link.eap.monitor.globalsetting.model.WirelessSettingModel;
import com.tp_link.eap.monitor.globalsetting.repo.GlobalEnableRepository;
import com.tp_link.eap.monitor.globalsetting.repo.HistoryRetentionSettingRepository;
import com.tp_link.eap.monitor.globalsetting.repo.LogSettingRepository;
import com.tp_link.eap.monitor.globalsetting.repo.ManagementVlanSettingRepository;
import com.tp_link.eap.monitor.globalsetting.repo.PortalSettingRepository;
import com.tp_link.eap.monitor.globalsetting.repo.QosSettingRepository;
import com.tp_link.eap.monitor.globalsetting.repo.SshSettingRepository;
import com.tp_link.eap.monitor.globalsetting.repo.SsidRepository;
import com.tp_link.eap.monitor.globalsetting.repo.TimeSettingRepository;
import com.tp_link.eap.monitor.globalsetting.repo.UserAccountSettingRepository;
import com.tp_link.eap.monitor.globalsetting.repo.WirelessSettingRepository;
import com.tp_link.eap.monitor.globalsetting.repo.impl.BandSteeringRepository;
import com.tp_link.eap.monitor.globalsetting.service.d;
import com.tp_link.eap.monitor.globalsetting.service.g;
import com.tp_link.eap.monitor.mesh.repo.MeshSettingRepository;
import com.tp_link.eap.monitor.record.service.a;
import com.tp_link.eap.monitor.roaming.repo.IRoamingSettingRepository;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.repo.filter.FilterRepository;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.restore.b;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.validation.Validator;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="globalSettingService")
public class GlobalSettingService
extends FilterRepository<PortalSetting>
implements d {
    private static final Logger b = LoggerFactory.getLogger(GlobalSettingService.class);
    @Autowired
    private LogSettingRepository c;
    @Autowired
    private PortalSettingRepository d;
    @Autowired
    private QosSettingRepository e;
    @Autowired
    private TimeSettingRepository f;
    @Autowired
    private UserAccountSettingRepository g;
    @Autowired
    private SshSettingRepository h;
    @Autowired
    ManagementVlanSettingRepository a;
    @Autowired
    private WirelessSettingRepository i;
    @Autowired
    private GlobalEnableRepository j;
    @Autowired
    private g k;
    @Autowired
    private a l;
    @Autowired
    private BandSteeringRepository m;
    @Autowired
    private MongoTemplate n;
    @Autowired
    private SsidRepository o;
    @Autowired
    private HistoryRetentionSettingRepository p;
    @Autowired
    private MeshSettingRepository q;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b r;
    @Autowired
    private com.tp_link.eap.monitor.mesh.service.a s;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.d t;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.a u;
    @Autowired
    private com.tp_link.eap.monitor.site.service.a v;
    @Autowired
    private Validator validator;
    @Autowired
    private IRoamingSettingRepository w;

    @Override
    public LogSetting getLogSetting() {
        String string = "log";
        return this.c.findByKeyAndSite(string, com.tp_link.eap.d.b.a());
    }

    @Override
    public OperationResponse saveLogSetting(LogSetting logSetting, boolean sendMessage) {
        String string = "log";
        if (logSetting == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        String string2 = com.tp_link.eap.d.b.a();
        logSetting.setSite(string2);
        com.tp_link.eap.d.b.g((String)string2);
        this.c.save(logSetting);
        if (sendMessage) {
            LogConfig logConfig = this.k.b();
            this.l.refreshRecord("logSetting", logConfig);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    @Deprecated
    public PortalSetting getPortalSetting() {
        String string = com.tp_link.eap.d.b.a();
        return this.d.findByKeyAndSite("portal", string);
    }

    @Override
    public PortalSetting getPortalSetting(String portalId) {
        return (PortalSetting)this.d.findOne((Serializable)((Object)portalId));
    }

    @Override
    public List<PortalSetting> getPortalSettingList() {
        String string = com.tp_link.eap.d.b.a();
        List<PortalSetting> list = this.d.findBySiteAndKey(string, "portal");
        for (PortalSetting portalSetting : list) {
            String string2 = portalSetting.getId();
            List<Ssid> list2 = this.o.findByPortalId(string2);
            HashSet<String> hashSet = new HashSet<String>();
            for (Ssid ssid : list2) {
                hashSet.add(ssid.getName());
            }
            portalSetting.setSelectedSsid(new ArrayList(hashSet));
        }
        return list;
    }

    @Override
    public List<PortalSetting> getPortalSettingList(Grid<PortalSetting> grid) {
        QuerySort.SortDirection sortDirection;
        QueryPage queryPage = grid.getQueryPage();
        QuerySort querySort = grid.getQuerySort();
        ArrayList arrayList = grid.getFilters();
        List list = grid.getSearchFilters();
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        Query query = this.getFilterQuery(list, arrayList);
        if (querySort != null) {
            sortDirection = querySort.getSortDirection();
            if (sortDirection.equals((Object)QuerySort.SortDirection.asc)) {
                query.with(new Sort(Sort.Direction.ASC, querySort.getSortKey()));
            } else {
                query.with(new Sort(Sort.Direction.DESC, querySort.getSortKey()));
            }
        }
        if (queryPage != null) {
            query.with((Pageable)new PageRequest(queryPage.getPage(), queryPage.getSize()));
        }
        new Criteria();
        sortDirection = Criteria.where((String)"key").is((Object)"portal");
        query.addCriteria((Criteria)sortDirection);
        List list2 = this.n.find(query, PortalSetting.class);
        for (PortalSetting portalSetting : list2) {
            String string = portalSetting.getId();
            List<Ssid> list3 = this.o.findByPortalId(string);
            HashSet<String> hashSet = new HashSet<String>();
            for (Ssid ssid : list3) {
                hashSet.add(ssid.getName());
            }
            portalSetting.setSelectedSsid(new ArrayList(hashSet));
        }
        return list2;
    }

    @Override
    public OperationResult savePortalSetting(PortalSetting portalSetting, boolean sendMessage) {
        if (portalSetting == null) {
            return com.tp_link.eap.util.e.aX;
        }
        String string = com.tp_link.eap.d.b.a();
        portalSetting.setSite(string);
        com.tp_link.eap.d.b.g((String)string);
        this.d.save(portalSetting);
        if (sendMessage) {
            List<PortalConfig> list = this.k.a();
            this.l.refreshRecord("portalConfigList", list);
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public QosSetting getQosSetting() {
        String string = "qos";
        return this.e.findByKeyAndSite(string, com.tp_link.eap.d.b.a());
    }

    @Override
    public OperationResponse saveQosSetting(QosSetting qosSetting, Integer radioId, boolean sendMessage) {
        String string = "qos";
        if (qosSetting == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        String string2 = com.tp_link.eap.d.b.a();
        com.tp_link.eap.d.b.g((String)string2);
        qosSetting.setSite(string2);
        this.e.save(qosSetting);
        if (sendMessage) {
            QosConfig qosConfig = null;
            switch (radioId) {
                case 0: {
                    qosConfig = this.k.b(radioId);
                    this.l.refreshRecord("qosConfig_2G", qosConfig);
                    break;
                }
                case 1: {
                    qosConfig = this.k.b(radioId);
                    this.l.refreshRecord("qosConfig_5G", qosConfig);
                    break;
                }
                case 2: {
                    QosConfig qosConfig2 = this.k.b(0);
                    QosConfig qosConfig3 = this.k.b(1);
                    this.l.refreshRecord("qosConfig_2G", qosConfig2);
                    this.l.refreshRecord("qosConfig_5G", qosConfig3);
                    break;
                }
                default: {
                    return new OperationResponse(ResErrorCode.d);
                }
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public TimeSetting getTimeSetting() {
        String string = "time";
        TimeSetting timeSetting = (TimeSetting)this.f.findOne((Serializable)((Object)string));
        if (timeSetting == null) {
            return null;
        }
        Long l2 = 0L;
        if (timeSetting.getDateTime() != null && timeSetting.getLastModifiedTime() != null) {
            l2 = new Date().getTime() - timeSetting.getLastModifiedTime();
            timeSetting.setDateTime(new Date(timeSetting.getDateTime().getTime() + l2));
        }
        return timeSetting;
    }

    @Override
    public OperationResult saveTimeSetting(TimeSetting timeSetting, int type, boolean sendMessage) {
        String string = "time";
        if (timeSetting == null) {
            return com.tp_link.eap.util.e.aX;
        }
        if (timeSetting.getId() == null || !timeSetting.getId().equals(string)) {
            timeSetting.setId(string);
        }
        this.k.g();
        timeSetting.setLastModifiedTime(Long.valueOf(new Date().getTime()));
        this.f.save(timeSetting);
        TimeSetting timeSetting2 = (TimeSetting)this.f.findOne((Serializable)((Object)string));
        if (timeSetting2 == null || !timeSetting2.toString().equals(timeSetting.toString())) {
            return com.tp_link.eap.util.e.bf;
        }
        if (sendMessage) {
            TimeConfig timeConfig = null;
            DaylightSaving daylightSaving = null;
            switch (type) {
                case 0: {
                    timeConfig = this.k.c();
                    break;
                }
                case 1: {
                    daylightSaving = this.k.e();
                    break;
                }
                case 2: {
                    timeConfig = this.k.c();
                    daylightSaving = this.k.e();
                    break;
                }
            }
            if (timeConfig != null) {
                this.l.refreshRecord("timeSetting", timeConfig);
            }
            if (daylightSaving != null) {
                this.l.refreshRecord("daylightSaving", daylightSaving);
            }
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public UserAccountSetting getUserAccountSetting() {
        String string = "userAccount";
        return this.g.findByKeyAndSite(string, com.tp_link.eap.d.b.a());
    }

    @Override
    public UserAccountSetting getUserAccountBySite(String Site2) {
        String string = "userAccount";
        return this.g.findByKeyAndSite(string, Site2);
    }

    @Override
    public OperationResponse setDeviceAccount(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("oldUserName");
        String string2 = jSONObject.optString("oldPassword");
        String string3 = jSONObject.optString("newUserName");
        String string4 = jSONObject.optString("newPassword");
        UserAccountSetting userAccountSetting = this.getUserAccountSetting();
        if (userAccountSetting == null) {
            b.error("No user account entry found in database.");
            return new OperationResponse(ResErrorCode.b);
        }
        String string5 = userAccountSetting.getUserName();
        String string6 = userAccountSetting.getPassword();
        if (!string6.equals(string2) || !string5.equals(string)) {
            b.warn("Old password/username is not corrected.");
            return new OperationResponse(ResErrorCode.s);
        }
        userAccountSetting.setPassword(string4);
        userAccountSetting.setUserName(string3);
        userAccountSetting.setOldName(string);
        userAccountSetting.setOldPassword(string2);
        return this.saveUserAccountSetting(userAccountSetting, true);
    }

    @Override
    public OperationResponse saveUserAccountSetting(UserAccountSetting userAccountSetting, boolean sendMessage) {
        if (userAccountSetting == null) {
            return new OperationResponse(ResErrorCode.b);
        }
        if (userAccountSetting.getKey() == null) {
            userAccountSetting.setKey("userAccount");
        }
        String string = com.tp_link.eap.d.b.a();
        userAccountSetting.setSite(string);
        com.tp_link.eap.d.b.g((String)string);
        this.g.save(userAccountSetting);
        if (sendMessage) {
            UserAccountConfig userAccountConfig = this.k.a(userAccountSetting);
            this.l.refreshRecord("userAccount", userAccountConfig);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public Wireless getWirelessSetting() {
        String string = "wireless";
        return this.i.findByKeyAndSite(string, com.tp_link.eap.d.b.a());
    }

    @Override
    public OperationResponse getAdvanceWirelessSetting(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.optInt("type");
        Wireless wireless = this.getWirelessSetting();
        WirelessSettingModel wirelessSettingModel = new WirelessSettingModel();
        if (n2 == 0) {
            wirelessSettingModel.setBasicRate(wireless.getBasicRate2g());
            wirelessSettingModel.setBeaconInterval(wireless.getBeaconInterval2g());
            wirelessSettingModel.setDtimPeriod(wireless.getDtimPeriod2g());
            wirelessSettingModel.setFragmentationThreshold(wireless.getFragmentationThreshold2g());
            wirelessSettingModel.setAirtimeFairness(wireless.getAirtimeFairness2g());
            wirelessSettingModel.setMcsIndex(wireless.getMcsIndex2g());
            wirelessSettingModel.setRtsThreshold(wireless.getRtsThreshold2g());
            wirelessSettingModel.setSupportRate(wireless.getSupportRate2g());
        } else {
            wirelessSettingModel.setBasicRate(wireless.getBasicRate5g());
            wirelessSettingModel.setBeaconInterval(wireless.getBeaconInterval5g());
            wirelessSettingModel.setDtimPeriod(wireless.getDtimPeriod5g());
            wirelessSettingModel.setFragmentationThreshold(wireless.getFragmentationThreshold5g());
            wirelessSettingModel.setAirtimeFairness(wireless.getAirtimeFairness5g());
            wirelessSettingModel.setMcsIndex(wireless.getMcsIndex5g());
            wirelessSettingModel.setRtsThreshold(wireless.getRtsThreshold5g());
            wirelessSettingModel.setSupportRate(wireless.getSupportRate5g());
        }
        OperationResponse operationResponse = new OperationResponse(ResErrorCode.a);
        operationResponse.setResult((Object)wirelessSettingModel);
        return operationResponse;
    }

    @Override
    public OperationResponse saveWirelessSetting(Wireless wirelessSetting, Integer radioId, boolean sendMessage) {
        String string = "wireless";
        if (wirelessSetting == null || radioId < 0 || radioId > 2) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (wirelessSetting.getKey() == null) {
            wirelessSetting.setKey(string);
        }
        String string2 = com.tp_link.eap.d.b.a();
        wirelessSetting.setSite(string2);
        com.tp_link.eap.d.b.g((String)string2);
        this.i.save(wirelessSetting);
        if (sendMessage) {
            WirelessAdvConfig wirelessAdvConfig = null;
            WirelessAdvConfig wirelessAdvConfig2 = null;
            switch (radioId) {
                case 0: {
                    wirelessAdvConfig = this.k.a(0);
                    break;
                }
                case 1: {
                    wirelessAdvConfig2 = this.k.a(1);
                    break;
                }
                case 2: {
                    wirelessAdvConfig = this.k.a(0);
                    wirelessAdvConfig2 = this.k.a(1);
                    break;
                }
                default: {
                    return com.tp_link.eap.util.e.aZ;
                }
            }
            if (wirelessAdvConfig != null) {
                this.l.refreshRecord("wirelessAdv_2G", wirelessAdvConfig);
            }
            if (wirelessAdvConfig2 != null) {
                this.l.refreshRecord("wirelessAdv_5G", wirelessAdvConfig2);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse modifyAdvanceWirelessSetting(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        WirelessSettingModel wirelessSettingModel = (WirelessSettingModel)JSONObject.toBean((JSONObject)jSONObject, WirelessSettingModel.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)wirelessSettingModel);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.r);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            String string2;
            if (!this.v.siteNameAlreadyExist(string)) {
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.r);
            }
            Wireless wireless = this.getWirelessSetting();
            if (wireless == null) {
                wireless = new Wireless();
            }
            if ("2.4GHz".equalsIgnoreCase(string2 = wirelessSettingModel.getPostType())) {
                wireless.setBeaconInterval2g(wirelessSettingModel.getBeaconInterval());
                wireless.setDtimPeriod2g(wirelessSettingModel.getDtimPeriod());
                wireless.setFragmentationThreshold2g(wirelessSettingModel.getFragmentationThreshold());
                wireless.setAirtimeFairness2g(wirelessSettingModel.getAirtimeFairness());
                wireless.setMcsIndex2g(wirelessSettingModel.getMcsIndex());
                wireless.setRtsThreshold2g(wirelessSettingModel.getRtsThreshold());
                wireless.setBasicRate2g(wirelessSettingModel.getBasicRate());
                wireless.setSupportRate2g(wirelessSettingModel.getSupportRate());
                return this.saveWirelessSetting(wireless, 0, true);
            }
            if ("5GHz".equalsIgnoreCase(string2)) {
                wireless.setBeaconInterval5g(wirelessSettingModel.getBeaconInterval());
                wireless.setDtimPeriod5g(wirelessSettingModel.getDtimPeriod());
                wireless.setFragmentationThreshold5g(wirelessSettingModel.getFragmentationThreshold());
                wireless.setAirtimeFairness5g(wirelessSettingModel.getAirtimeFairness());
                wireless.setMcsIndex5g(wirelessSettingModel.getMcsIndex());
                wireless.setRtsThreshold5g(wirelessSettingModel.getRtsThreshold());
                wireless.setBasicRate5g(wirelessSettingModel.getBasicRate());
                wireless.setSupportRate5g(wirelessSettingModel.getSupportRate());
                return this.saveWirelessSetting(wireless, 1, true);
            }
            return com.tp_link.eap.util.e.aZ;
        }
    }

    @Override
    public boolean getMacFiltering() {
        GlobalEnable globalEnable = this.getGlobalEnbale();
        return globalEnable.getMacFilteringEnable();
    }

    @Override
    public boolean getSchedultering() {
        GlobalEnable globalEnable = this.getGlobalEnbale();
        return globalEnable.getSchedulerEnable();
    }

    @Override
    public HistoryRetentionSetting getHistoryRetentionSetting() {
        HistoryRetentionSetting historyRetentionSetting = this.p.findByKey("historyRetention");
        if (historyRetentionSetting == null) {
            historyRetentionSetting = new HistoryRetentionSetting();
            historyRetentionSetting.setRetention(Integer.valueOf(365));
            historyRetentionSetting.setKey("historyRetention");
            this.p.save(historyRetentionSetting);
        }
        return historyRetentionSetting;
    }

    @Override
    public OperationResult saveHistoryRetentionSetting(HistoryRetentionSetting hrs) {
        HistoryRetentionSetting historyRetentionSetting = this.p.findByKey("historyRetention");
        if (historyRetentionSetting != null) {
            historyRetentionSetting.setRetention(hrs.getRetention());
            this.p.save(historyRetentionSetting);
        } else {
            this.p.save(hrs);
        }
        return new OperationResult(true, null);
    }

    @Override
    public boolean getLedStatus() {
        GlobalEnable globalEnable = this.getGlobalEnbale();
        return globalEnable.getLedOn();
    }

    @Override
    public SshSetting getSshSetting() {
        String string = "ssh";
        return this.h.findByKeyAndSite(string, com.tp_link.eap.d.b.a());
    }

    @Override
    public OperationResult saveSshSetting(SshSetting sshSetting, boolean sendMessage) {
        String string = "ssh";
        if (sshSetting == null) {
            return com.tp_link.eap.util.e.aX;
        }
        if (sshSetting.getKey() == null) {
            sshSetting.setKey(string);
        }
        String string2 = com.tp_link.eap.d.b.a();
        sshSetting.setSite(string2);
        com.tp_link.eap.d.b.g((String)string2);
        this.h.save(sshSetting);
        if (sendMessage) {
            SshConfig sshConfig = this.k.a(sshSetting);
            this.l.refreshRecord("ssh", sshConfig);
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public ManagementVlanSetting getManagementVlanSetting() {
        String string = "managementVlan";
        return this.a.findByKeyAndSite(string, com.tp_link.eap.d.b.a());
    }

    @Override
    public OperationResult saveManagementVlanSetting(ManagementVlanSetting managementVlanSetting, boolean sendMessage) {
        String string = "managementVlan";
        if (managementVlanSetting == null) {
            return com.tp_link.eap.util.e.aX;
        }
        if (managementVlanSetting.getKey() == null) {
            managementVlanSetting.setKey(string);
        }
        String string2 = com.tp_link.eap.d.b.a();
        managementVlanSetting.setSite(string2);
        com.tp_link.eap.d.b.g((String)string2);
        this.a.save(managementVlanSetting);
        if (sendMessage) {
            ManagementVlanConfig managementVlanConfig = this.k.a(managementVlanSetting);
            this.l.refreshRecord("managementVlan", managementVlanConfig);
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public GlobalEnable getGlobalEnbale() {
        String string = "globalEnable";
        String string2 = com.tp_link.eap.d.b.a();
        GlobalEnable globalEnable = this.j.findByKeyAndSite(string, string2);
        if (globalEnable == null) {
            globalEnable = new GlobalEnable();
            globalEnable.setKey(string);
            globalEnable.setLedOn(Boolean.valueOf(false));
            globalEnable.setMacFilteringEnable(Boolean.valueOf(false));
            globalEnable.setSchedulerEnable(Boolean.valueOf(false));
            globalEnable.setSite(string2);
            com.tp_link.eap.d.b.g((String)string2);
            this.j.save(globalEnable);
        }
        return globalEnable;
    }

    @Override
    public OperationResponse saveGlobalEnable(GlobalEnable globalEnable, String keyType) {
        if (globalEnable == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        String string = com.tp_link.eap.d.b.a();
        globalEnable.setSite(string);
        com.tp_link.eap.d.b.g((String)string);
        this.j.save(globalEnable);
        switch (keyType) {
            case "macFilteringEnable": {
                MacFilterGlobal macFilterGlobal = this.k.a(globalEnable.getMacFilteringEnable());
                this.l.refreshRecord("macFilterGlobal", macFilterGlobal);
                break;
            }
            case "schedulerEnable": {
                SchedulerGlobal schedulerGlobal = this.k.a(globalEnable.getSchedulerEnable(), globalEnable.getAssociationMode());
                this.l.refreshRecord("schedulerGlobal", schedulerGlobal);
                break;
            }
            case "ledOn": {
                Led led = this.k.b(globalEnable.getLedOn());
                this.l.refreshRecord("led", led);
                break;
            }
            case "wirelessRadioEnable24": {
                break;
            }
            case "wirelessRadioEnable5": {
                break;
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public boolean saveGlobalEnable(GlobalEnable globalEnable, boolean sendMessage) {
        if (globalEnable == null) {
            return false;
        }
        String string = com.tp_link.eap.d.b.a();
        globalEnable.setSite(string);
        com.tp_link.eap.d.b.g((String)string);
        this.j.save(globalEnable);
        if (sendMessage) {
            MacFilterGlobal macFilterGlobal = this.k.a(true);
            this.l.refreshRecord("macFilterGlobal", macFilterGlobal);
            SchedulerGlobal schedulerGlobal = this.k.a(globalEnable.getSchedulerEnable(), globalEnable.getAssociationMode());
            this.l.refreshRecord("schedulerGlobal", schedulerGlobal);
            Led led = this.k.b(globalEnable.getLedOn());
            this.l.refreshRecord("led", led);
        }
        return true;
    }

    @Override
    public void initGlobalEnable(GlobalEnable globalEnable) {
        if (null != globalEnable) {
            String string = com.tp_link.eap.d.b.a();
            globalEnable.setSite(string);
            com.tp_link.eap.d.b.g((String)string);
            this.j.save(globalEnable);
        }
    }

    @Override
    public void initSsh(SshSetting sshSetting) {
        String string = "ssh";
        if (sshSetting == null) {
            return;
        }
        String string2 = com.tp_link.eap.d.b.a();
        sshSetting.setSite(string2);
        sshSetting.setKey(string);
        com.tp_link.eap.d.b.g((String)string2);
        this.k.g();
        this.h.save(sshSetting);
    }

    @Override
    public void initManagementVlan(ManagementVlanSetting managementVlanSetting) {
        String string = "managementVlan";
        if (managementVlanSetting == null) {
            return;
        }
        String string2 = com.tp_link.eap.d.b.a();
        managementVlanSetting.setSite(string2);
        managementVlanSetting.setKey(string);
        com.tp_link.eap.d.b.g((String)string2);
        this.k.g();
        this.a.save(managementVlanSetting);
    }

    @Override
    public void initUserAccountSetting(UserAccountSetting userAccountSetting) {
        String string = "userAccount";
        if (userAccountSetting == null) {
            return;
        }
        String string2 = com.tp_link.eap.d.b.a();
        userAccountSetting.setSite(string2);
        userAccountSetting.setKey(string);
        com.tp_link.eap.d.b.g((String)string2);
        this.k.g();
        this.g.save(userAccountSetting);
    }

    @Override
    public void initWireless(Wireless wirelessSetting) {
        if (wirelessSetting == null) {
            return;
        }
        wirelessSetting.setAirtimeFairness2g(Boolean.valueOf(false));
        wirelessSetting.setAirtimeFairness5g(Boolean.valueOf(false));
        String string = com.tp_link.eap.d.b.a();
        wirelessSetting.setSite(string);
        wirelessSetting.setKey("wireless");
        com.tp_link.eap.d.b.g((String)string);
        this.i.save(wirelessSetting);
    }

    @Override
    public void initPortalSetting(PortalSetting portalSetting) {
        String string = "portal";
        if (portalSetting == null) {
            return;
        }
        if (portalSetting.getKey() == null || !portalSetting.getKey().equals(string)) {
            portalSetting.setKey(string);
        }
        String string2 = com.tp_link.eap.d.b.a();
        portalSetting.setSite(string2);
        com.tp_link.eap.d.b.g((String)string2);
        this.d.save(portalSetting);
    }

    @Override
    public void initLogSetting(LogSetting logSetting) {
        String string = "log";
        if (logSetting == null) {
            return;
        }
        String string2 = com.tp_link.eap.d.b.a();
        logSetting.setSite(string2);
        logSetting.setKey(string);
        com.tp_link.eap.d.b.g((String)string2);
        this.c.save(logSetting);
    }

    @Override
    public void initQosSetting(QosSetting qosSetting) {
        String string = "qos";
        if (qosSetting == null) {
            return;
        }
        String string2 = com.tp_link.eap.d.b.a();
        qosSetting.setSite(string2);
        qosSetting.setKey(string);
        com.tp_link.eap.d.b.g((String)string2);
        this.e.save(qosSetting);
    }

    @Override
    public void initTimeSetting(TimeSetting timeSetting) {
        String string = "time";
        if (timeSetting == null) {
            return;
        }
        if (timeSetting.getId() == null || !timeSetting.getId().equals(string)) {
            timeSetting.setId(string);
        }
        this.k.g();
        timeSetting.setLastModifiedTime(Long.valueOf(new Date().getTime()));
        this.f.save(timeSetting);
    }

    @Override
    public void initBandSteering() {
        BandSteering bandSteering = new BandSteering();
        bandSteering.setSite(com.tp_link.eap.d.b.a());
        bandSteering.setKey("bandSteering");
        bandSteering.setDifferenceThreshold(4);
        bandSteering.setConnectionThreshold(20);
        bandSteering.setMaxFailures(10);
        bandSteering.setEnable(false);
        this.m.save(bandSteering);
    }

    @Override
    public void initBackupData(String jsonString) {
        BackupInitData backupInitData = new BackupInitData();
        backupInitData.setId("backupInit");
        backupInitData.setJsonData(jsonString);
        this.n.insert((Object)backupInitData);
    }

    @Override
    public Object getBackupDataById(String keyId) {
        if (keyId == null) {
            return null;
        }
        if (keyId.equals("qos")) {
            BackupInitData backupInitData = (BackupInitData)this.n.findById((Object)"backupInit", BackupInitData.class);
            if (backupInitData == null) {
                return null;
            }
            Data data = (Data)com.tp_link.eap.util.a.b.a((String)backupInitData.getJsonData(), Data.class);
            QosSetting qosSetting = data.getQosSetting();
            return qosSetting;
        }
        return null;
    }

    @Override
    public boolean isQoSWmmDisabled(int radioId) {
        QosSetting qosSetting = this.getQosSetting();
        return radioId == 0 ? !qosSetting.getWmmEnable24().booleanValue() : qosSetting.getWmmEnable5() == false;
    }

    @Override
    public void deleteBySite() {
        RoamingSetting roamingSetting;
        MeshSetting meshSetting;
        ManagementVlanSetting managementVlanSetting;
        SshSetting sshSetting;
        BandSteering bandSteering;
        Wireless wireless;
        UserAccountSetting userAccountSetting;
        LogSetting logSetting;
        String string = com.tp_link.eap.d.b.a();
        GlobalEnable globalEnable = this.j.findByKeyAndSite("globalEnable", string);
        if (globalEnable != null) {
            this.j.delete(globalEnable);
        }
        if ((logSetting = this.c.findByKeyAndSite("log", string)) != null) {
            this.c.delete(logSetting);
        }
        this.d.deleteByKeyAndSite("portal", string);
        QosSetting qosSetting = this.e.findByKeyAndSite("qos", string);
        if (qosSetting != null) {
            this.e.delete(qosSetting);
        }
        if ((userAccountSetting = this.g.findByKeyAndSite("userAccount", string)) != null) {
            this.g.delete(userAccountSetting);
        }
        if ((wireless = this.i.findByKeyAndSite("wireless", string)) != null) {
            this.i.delete(wireless);
        }
        if ((bandSteering = this.m.findByKeyAndSite("bandSteering", string)) != null) {
            this.m.delete(bandSteering);
        }
        if ((sshSetting = this.h.findByKeyAndSite("ssh", string)) != null) {
            this.h.delete(sshSetting);
        }
        if ((managementVlanSetting = this.a.findByKeyAndSite("managementVlan", string)) != null) {
            this.a.delete(managementVlanSetting);
        }
        if ((meshSetting = this.q.findByKeyAndSite("mesh", string)) != null) {
            this.q.delete(meshSetting);
        }
        if (null != (roamingSetting = this.w.findByKeyAndSite("roaming", string))) {
            this.w.delete(roamingSetting);
        }
    }

    @Override
    public BandSteering getBandSteering() {
        String string = com.tp_link.eap.d.b.a();
        return this.m.findByKeyAndSite("bandSteering", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse getBandSteering(ControlType controlType, JSONObject reqObj) {
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.r);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (!this.v.siteNameAlreadyExist(string)) {
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.r);
            }
            BandSteering bandSteering = this.getBandSteering();
            OperationResponse operationResponse = new OperationResponse(ResErrorCode.a);
            operationResponse.setResult((Object)bandSteering);
            return operationResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse refreshBandSteering(BandSteering bs) {
        String string;
        if (bs == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (bs.isEnable()) {
            boolean bl = true;
            bl = com.tp_link.eap.util.p.c.a((int)bs.getConnectionThreshold(), (int)2, (int)40);
            if (!bl) {
                return new OperationResponse(ResErrorCode.F);
            }
            bl = com.tp_link.eap.util.p.c.a((int)bs.getDifferenceThreshold(), (int)1, (int)8);
            if (!bl) {
                return new OperationResponse(ResErrorCode.G);
            }
            bl = com.tp_link.eap.util.p.c.a((int)bs.getMaxFailures(), (int)0, (int)100);
            if (!bl) {
                return new OperationResponse(ResErrorCode.H);
            }
        }
        if (com.tp_link.eap.util.a.e.a((String)(string = com.tp_link.eap.d.b.a()))) {
            return new OperationResponse(ResErrorCode.r);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (!this.v.siteNameAlreadyExist(string)) {
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.r);
            }
            BandSteering bandSteering = this.getBandSteering();
            if (bandSteering == null) {
                return new OperationResponse(ResErrorCode.I);
            }
            bandSteering.setEnable(bs.isEnable());
            if (bs.isEnable()) {
                bandSteering.setConnectionThreshold(bs.getConnectionThreshold());
                bandSteering.setDifferenceThreshold(bs.getDifferenceThreshold());
                bandSteering.setMaxFailures(bs.getMaxFailures());
            }
            this.m.save(bandSteering);
        }
        this.l.refreshRecord("bandSteering", bs);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse modifyBandSteering(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        BandSteering bandSteering = (BandSteering)JSONObject.toBean((JSONObject)jSONObject, BandSteering.class);
        return this.refreshBandSteering(bandSteering);
    }

    @Override
    public void initMeshSetting() {
        String string = com.tp_link.eap.d.b.a();
        MeshSetting meshSetting = new MeshSetting();
        meshSetting.setKey("mesh");
        meshSetting.setMeshEnable(true);
        meshSetting.setAutoFailoverEnable(false);
        meshSetting.setDefGatewayEnable(0);
        meshSetting.setGateway("");
        meshSetting.setSite(string);
        com.tp_link.eap.d.b.g((String)string);
        this.q.save(meshSetting);
    }

    @Override
    public MeshSetting getMeshSetting() {
        String string = com.tp_link.eap.d.b.a();
        String string2 = "mesh";
        MeshSetting meshSetting = this.q.findByKeyAndSite(string2, string);
        return meshSetting;
    }

    @Override
    public MeshSetting getMeshSettingByMac(String mac) {
        Ap ap = this.r.getApByMac(mac);
        String string = null;
        if (ap != null && !ap.getSite().equals("PENDING-SITE")) {
            string = ap.getSite();
        }
        if (string == null) {
            return null;
        }
        MeshSetting meshSetting = this.q.findByKeyAndSite("mesh", string);
        return meshSetting;
    }

    @Override
    public List<MeshSetting> getMeshSettingList() {
        String string = "mesh";
        List<MeshSetting> list = this.q.findByKey(string);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse saveMeshSetting(MeshSetting meshSetting, boolean sendMessage) {
        if (meshSetting == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (meshSetting.isMeshEnable() && meshSetting.getDefGatewayEnable() == 1 && StringUtils.isEmpty((String)meshSetting.getGateway())) {
            b.warn("Invalid input parameters of mesh setting");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = com.tp_link.eap.d.b.a();
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (!this.v.siteNameAlreadyExist(string)) {
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.r);
            }
            MeshSetting meshSetting2 = this.q.findByKeyAndSite("mesh", string);
            if (meshSetting2 == null) {
                b.error("Failed to find oldMeshSetting for site {}", (Object)string);
                return com.tp_link.eap.util.e.bg;
            }
            int n2 = this.a(meshSetting, meshSetting2);
            if (n2 < 0) {
                return com.tp_link.eap.util.e.bd;
            }
            if (n2 == 3) {
                sendMessage = false;
            }
            meshSetting2.setMeshEnable(meshSetting.isMeshEnable());
            meshSetting2.setAutoFailoverEnable(meshSetting.isAutoFailoverEnable());
            meshSetting2.setDefGatewayEnable(meshSetting.getDefGatewayEnable());
            meshSetting2.setGateway(meshSetting.getGateway());
            this.q.save(meshSetting2);
            com.tp_link.eap.d.b.g((String)string);
            if (sendMessage) {
                this.s.sendMeshSetting(meshSetting, string, n2);
            }
            return com.tp_link.eap.util.e.bd;
        }
    }

    private int a(MeshSetting meshSetting, MeshSetting meshSetting2) {
        if (meshSetting2.isMeshEnable() && !meshSetting.isMeshEnable()) {
            return 0;
        }
        if (!meshSetting2.isMeshEnable() && meshSetting.isMeshEnable()) {
            return 1;
        }
        if (meshSetting2.isMeshEnable() == meshSetting.isMeshEnable()) {
            if (!meshSetting2.isMeshEnable()) {
                return -1;
            }
            if (meshSetting2.getDefGatewayEnable() == meshSetting.getDefGatewayEnable()) {
                if (meshSetting2.getDefGatewayEnable() == 0) {
                    if (meshSetting2.isAutoFailoverEnable() == meshSetting.isAutoFailoverEnable()) {
                        return -1;
                    }
                    return 3;
                }
                if (!(com.tp_link.eap.util.a.e.a((String)meshSetting2.getGateway()) || com.tp_link.eap.util.a.e.a((String)meshSetting.getGateway()) || meshSetting2.getGateway().equals(meshSetting.getGateway()))) {
                    return 2;
                }
                if (meshSetting2.isAutoFailoverEnable() == meshSetting.isAutoFailoverEnable()) {
                    return -1;
                }
                return 3;
            }
            return 2;
        }
        return -1;
    }

    @Override
    public OperationResponse getGlobalStat(ControlType controlType, JSONObject reqObj) {
        ArrayList<QueryFilter> arrayList = new ArrayList<QueryFilter>();
        arrayList.add(new QueryFilter("status", (Object)1, QueryFilter.FilterType.eq));
        long l2 = this.r.count(arrayList, null);
        arrayList.clear();
        arrayList.add(new QueryFilter("status", (Object)0, QueryFilter.FilterType.eq));
        long l3 = this.r.count(arrayList, null);
        arrayList.clear();
        arrayList.add(new QueryFilter("status", (Object)2, QueryFilter.FilterType.eq));
        long l4 = this.r.count(arrayList, null);
        arrayList.clear();
        arrayList.add(new QueryFilter("status", (Object)4, QueryFilter.FilterType.eq));
        long l5 = this.r.count(arrayList, null);
        arrayList.clear();
        arrayList.add(new QueryFilter("isActive", (Object)true, QueryFilter.FilterType.eq));
        arrayList.add(new QueryFilter("isGuest", (Object)true, QueryFilter.FilterType.eq));
        long l6 = this.t.count(arrayList, null);
        arrayList.clear();
        arrayList.add(new QueryFilter("isActive", (Object)true, QueryFilter.FilterType.eq));
        arrayList.add(new QueryFilter("isGuest", (Object)false, QueryFilter.FilterType.eq));
        long l7 = this.t.count(arrayList, null);
        arrayList.clear();
        arrayList.add(new QueryFilter("archived", (Object)false, QueryFilter.FilterType.eq));
        long l8 = this.u.count(arrayList, null);
        GlobalStatInfo globalStatInfo = new GlobalStatInfo(l2, l3, l4, l5, l6, l7, l8);
        return new OperationResponse(ResErrorCode.a, (Object)globalStatInfo);
    }

    @Override
    public OperationResponse getLogSetting(ControlType controlType, JSONObject reqObj) {
        LogSetting logSetting = this.getLogSetting();
        if (logSetting == null) {
            return null;
        }
        LogSettingInfo logSettingInfo = new LogSettingInfo();
        logSettingInfo.setAutoMailEnable(logSetting.getAutoMailEnable());
        logSettingInfo.setFromAddress(logSetting.getFromAddress());
        logSettingInfo.setToAddress(logSetting.getToAddress());
        logSettingInfo.setAuthEnable(logSetting.getAuthEnable());
        logSettingInfo.setPassword(logSetting.getPassword());
        logSettingInfo.setPort(logSetting.getPort());
        logSettingInfo.setServer(logSetting.getServer());
        logSettingInfo.setUserName(logSetting.getUserName());
        logSettingInfo.setTimeMode(logSetting.getTimeMode());
        logSettingInfo.setFixationTimeH(logSetting.getFixationTimeH());
        logSettingInfo.setFixationTimeM(logSetting.getFixationTimeM());
        logSettingInfo.setPeriodTime(logSetting.getPeriodTime());
        logSettingInfo.setServerEnable(logSetting.getServerEnable());
        logSettingInfo.setLogServerIp(logSetting.getLogServerIp());
        logSettingInfo.setLogServerPort(logSetting.getLogServerPort());
        return new OperationResponse(ResErrorCode.a, (Object)logSetting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse modifyLogSetting(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        LogSettingInfo logSettingInfo = (LogSettingInfo)JSONObject.toBean((JSONObject)jSONObject, LogSettingInfo.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)logSettingInfo);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.r);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (!this.v.siteNameAlreadyExist(string)) {
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.r);
            }
            LogSetting logSetting = this.getLogSetting();
            if (logSetting == null) {
                logSetting = new LogSetting();
            }
            logSetting.setAutoMailEnable(logSettingInfo.getAutoMailEnable());
            if (logSettingInfo.getAutoMailEnable().booleanValue()) {
                logSetting.setFromAddress(logSettingInfo.getFromAddress());
                logSetting.setToAddress(logSettingInfo.getToAddress());
                logSetting.setAuthEnable(logSettingInfo.getAuthEnable());
                if (logSettingInfo.getAuthEnable().booleanValue()) {
                    logSetting.setPassword(logSettingInfo.getPassword() != null ? logSettingInfo.getPassword() : "");
                    logSetting.setUserName(logSettingInfo.getUserName());
                }
                logSetting.setPort(logSettingInfo.getPort());
                logSetting.setServer(logSettingInfo.getServer());
                logSetting.setTimeMode(logSettingInfo.getTimeMode());
                if (logSettingInfo.getTimeMode().equals("Period Time")) {
                    logSetting.setPeriodTime(logSettingInfo.getPeriodTime());
                } else {
                    logSetting.setFixationTimeH(logSettingInfo.getFixationTimeH());
                    logSetting.setFixationTimeM(logSettingInfo.getFixationTimeM());
                }
                logSetting.setLogClientDetailAMF(logSettingInfo.getLogClientDetailAMF());
            }
            logSetting.setServerEnable(logSettingInfo.getServerEnable());
            if (logSettingInfo.getServerEnable().booleanValue()) {
                logSetting.setLogServerIp(logSettingInfo.getLogServerIp());
                logSetting.setLogServerPort(logSettingInfo.getLogServerPort());
                logSetting.setLogClientDetailLS(logSettingInfo.getLogClientDetailLS());
            }
            return this.saveLogSetting(logSetting, true);
        }
    }

    @Override
    public OperationResponse getDeviceAccount(ControlType controlType, JSONObject reqObj) {
        UserAccountSetting userAccountSetting = this.getUserAccountSetting();
        if (userAccountSetting == null) {
            return null;
        }
        UserAccountInfo userAccountInfo = new UserAccountInfo();
        userAccountInfo.setOldUserName(userAccountSetting.getUserName());
        userAccountInfo.setOldPassword(userAccountSetting.getPassword());
        b.debug("*******entry:*******{}", (Object)userAccountInfo);
        return new OperationResponse(ResErrorCode.a, (Object)userAccountInfo);
    }

    @Override
    public OperationResponse getMoreSettings(ControlType controlType, JSONObject reqObj) {
        MoreSettingsInfo moreSettingsInfo = new MoreSettingsInfo();
        HistoryRetentionSetting historyRetentionSetting = this.getHistoryRetentionSetting();
        moreSettingsInfo.setHistoryRetention(historyRetentionSetting.getRetention());
        GlobalEnable globalEnable = this.getGlobalEnbale();
        moreSettingsInfo.setLedOn(globalEnable.getLedOn());
        SshSetting sshSetting = this.getSshSetting();
        moreSettingsInfo.setSshEnable(sshSetting.getSshenable());
        moreSettingsInfo.setSshServerPort(sshSetting.getSshserverPort());
        ManagementVlanSetting managementVlanSetting = this.getManagementVlanSetting();
        moreSettingsInfo.setManagementVlanEnable(managementVlanSetting.getManagementVlanEnable());
        moreSettingsInfo.setManagementVlanId(managementVlanSetting.getManagementVlanId());
        return new OperationResponse(ResErrorCode.a, (Object)moreSettingsInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public OperationResponse modifyMoreSettings(ControlType controlType, JSONObject reqObj) {
        Object object;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        MoreSettingsInfo moreSettingsInfo = (MoreSettingsInfo)JSONObject.toBean((JSONObject)jSONObject, MoreSettingsInfo.class);
        Object object2 = com.tp_link.eap.b.b.a.a;
        synchronized (object2) {
            object = this.getHistoryRetentionSetting();
            if (object == null) {
                return new OperationResponse(ResErrorCode.i);
            }
            if (moreSettingsInfo.getHistoryRetention() != null && !moreSettingsInfo.getHistoryRetention().equals(object.getRetention()) && SecurityUtils.getSubject().hasRole("administrator")) {
                object.setRetention(moreSettingsInfo.getHistoryRetention());
                this.saveHistoryRetentionSetting((HistoryRetentionSetting)object);
            }
        }
        object2 = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)object2)) {
            return new OperationResponse(ResErrorCode.r);
        }
        object = com.tp_link.eap.b.b.a.l((String)object2);
        synchronized (object) {
            ManagementVlanSetting managementVlanSetting;
            SshSetting sshSetting;
            if (!this.v.siteNameAlreadyExist((String)object2)) {
                com.tp_link.eap.b.b.a.m((String)object2);
                return new OperationResponse(ResErrorCode.r);
            }
            GlobalEnable globalEnable = this.getGlobalEnbale();
            if (globalEnable == null) {
                return new OperationResponse(ResErrorCode.i);
            }
            if (moreSettingsInfo.getLedOn() == null) {
                return new OperationResponse(ResErrorCode.d);
            }
            if (!moreSettingsInfo.getLedOn().equals(globalEnable.getLedOn())) {
                globalEnable.setLedOn(moreSettingsInfo.getLedOn());
                this.saveGlobalEnable(globalEnable, "ledOn");
            }
            if ((sshSetting = this.getSshSetting()) == null) {
                return new OperationResponse(ResErrorCode.i);
            }
            if (moreSettingsInfo.getSshEnable() == null || moreSettingsInfo.getSshServerPort() == null) {
                return new OperationResponse(ResErrorCode.d);
            }
            if (!moreSettingsInfo.getSshEnable().equals(sshSetting.getSshenable()) || !moreSettingsInfo.getSshServerPort().equals(sshSetting.getSshserverPort())) {
                sshSetting.setSshenable(moreSettingsInfo.getSshEnable());
                sshSetting.setSshserverPort(moreSettingsInfo.getSshServerPort());
                this.saveSshSetting(sshSetting, true);
            }
            if ((managementVlanSetting = this.getManagementVlanSetting()) == null) {
                return new OperationResponse(ResErrorCode.i);
            }
            if (moreSettingsInfo.isManagementVlanEnable() == null || moreSettingsInfo.getManagementVlanId() == null) {
                return new OperationResponse(ResErrorCode.d);
            }
            if (!moreSettingsInfo.isManagementVlanEnable().equals(managementVlanSetting.getManagementVlanEnable()) || !moreSettingsInfo.getManagementVlanId().equals(managementVlanSetting.getManagementVlanId())) {
                managementVlanSetting.setManagementVlanEnable(moreSettingsInfo.isManagementVlanEnable());
                managementVlanSetting.setManagementVlanId(moreSettingsInfo.getManagementVlanId());
                this.saveManagementVlanSetting(managementVlanSetting, true);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse getGlobalEnableSetting(ControlType controlType, JSONObject reqObj) {
        return new OperationResponse(ResErrorCode.a, (Object)this.getGlobalEnbale());
    }

    @Override
    public OperationResponse modifyGlobalEnableSetting(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        GlobalEnableInfo globalEnableInfo = (GlobalEnableInfo)JSONObject.toBean((JSONObject)jSONObject, GlobalEnableInfo.class);
        String string = globalEnableInfo.getKeyType();
        if (string.equals("macFilteringEnable")) {
            GlobalEnable globalEnable = this.getGlobalEnbale();
            globalEnable.setMacFilteringEnable(globalEnableInfo.getMacFilteringEnable());
            return this.saveGlobalEnable(globalEnable, string);
        }
        if (string.equals("schedulerEnable")) {
            GlobalEnable globalEnable = this.getGlobalEnbale();
            globalEnable.setSchedulerEnable(globalEnableInfo.getSchedulerEnable());
            globalEnable.setAssociationMode(globalEnableInfo.getAssociationMode());
            return this.saveGlobalEnable(globalEnable, string);
        }
        if (string.equals("ledOn")) {
            GlobalEnable globalEnable = this.getGlobalEnbale();
            globalEnable.setLedOn(globalEnableInfo.getLedOn());
            return this.saveGlobalEnable(globalEnable, string);
        }
        return new OperationResponse(ResErrorCode.d);
    }

    @Override
    public OperationResponse getAboutInfo(ControlType controlType, JSONObject reqObj) {
        Configuration configuration = com.tp_link.eap.configuration.a.a((String)"eap.properties");
        if (configuration != null) {
            String string = configuration.getProperty("eap.version");
            String string2 = configuration.getProperty("eap.copyright");
            AboutInfo aboutInfo = new AboutInfo(string, string2);
            return new OperationResponse(ResErrorCode.a, (Object)aboutInfo);
        }
        b.warn("Load configuration failed.");
        return new OperationResponse(ResErrorCode.f);
    }

    @Override
    public OperationResponse getGridPortalSettings(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        if (com.tp_link.eap.util.a.e.a((String)queryData.getSortName())) {
            queryData.setSortName("id");
            queryData.setSortOrder("asc");
        }
        grid.initFilters(queryData.getFilters());
        long l2 = this.getPortalSettingList().size();
        grid.setTotalRows(l2);
        List<PortalSetting> list = this.getPortalSettingList((Grid<PortalSetting>)grid);
        int n2 = queryData.getCurrentPage();
        int n3 = queryData.getCurrentPageSize();
        int n4 = (n2 - 1) * n3;
        int n5 = 1;
        for (PortalSetting portalSetting : list) {
            portalSetting.setIndex(Integer.valueOf(n4 + n5++));
        }
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse getQosSetting(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("keyType");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        QosSetting qosSetting = this.getQosSetting();
        if (qosSetting == null) {
            return new OperationResponse(ResErrorCode.a, null);
        }
        QosSettingInfo qosSettingInfo = new QosSettingInfo();
        if (string.equals("2.4GHz")) {
            qosSettingInfo.setApEdcaParams(qosSetting.getApEdcaParams24());
            qosSettingInfo.setStationEdcaParams(qosSetting.getStationEdcaParams24());
            qosSettingInfo.setDeliveryEnable(qosSetting.getDeliveryEnable24());
            qosSettingInfo.setNoAcknowledgement(qosSetting.getNoAcknowledgement24());
            qosSettingInfo.setWmmEnable(qosSetting.getWmmEnable24());
        } else if (string.equals("5GHz")) {
            qosSettingInfo.setApEdcaParams(qosSetting.getApEdcaParams5());
            qosSettingInfo.setStationEdcaParams(qosSetting.getStationEdcaParams5());
            qosSettingInfo.setDeliveryEnable(qosSetting.getDeliveryEnable5());
            qosSettingInfo.setNoAcknowledgement(qosSetting.getNoAcknowledgement5());
            qosSettingInfo.setWmmEnable(qosSetting.getWmmEnable5());
        } else {
            return new OperationResponse(ResErrorCode.a, null);
        }
        return new OperationResponse(ResErrorCode.a, (Object)qosSettingInfo);
    }

    @Override
    public OperationResponse getInitQosSetting(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("keyType");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        QosSetting qosSetting = (QosSetting)this.getBackupDataById("qos");
        if (qosSetting == null) {
            return new OperationResponse(ResErrorCode.a, null);
        }
        QosSettingInfo qosSettingInfo = new QosSettingInfo();
        if (string.equals("2.4GHz")) {
            qosSettingInfo.setApEdcaParams(qosSetting.getApEdcaParams24());
            qosSettingInfo.setStationEdcaParams(qosSetting.getStationEdcaParams24());
            qosSettingInfo.setDeliveryEnable(qosSetting.getDeliveryEnable24());
            qosSettingInfo.setNoAcknowledgement(qosSetting.getNoAcknowledgement24());
            qosSettingInfo.setWmmEnable(qosSetting.getWmmEnable24());
        } else if (string.equals("5GHz")) {
            qosSettingInfo.setApEdcaParams(qosSetting.getApEdcaParams5());
            qosSettingInfo.setStationEdcaParams(qosSetting.getStationEdcaParams5());
            qosSettingInfo.setDeliveryEnable(qosSetting.getDeliveryEnable5());
            qosSettingInfo.setNoAcknowledgement(qosSetting.getNoAcknowledgement5());
            qosSettingInfo.setWmmEnable(qosSetting.getWmmEnable5());
        } else {
            return new OperationResponse(ResErrorCode.a, null);
        }
        return new OperationResponse(ResErrorCode.a, (Object)qosSettingInfo);
    }

    @Override
    public OperationResponse modifyQosSetting(ControlType controlType, JSONObject reqObj) {
        OperationResponse operationResponse;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        QosSettingInfo qosSettingInfo = null;
        try {
            qosSettingInfo = (QosSettingInfo)com.tp_link.eap.util.a.b.a((String)jSONObject.toString(), QosSettingInfo.class);
        }
        catch (c c2) {
            b.warn("Invalid request params.");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!this.a(qosSettingInfo)) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = qosSettingInfo.getKeyType();
        Boolean bl = qosSettingInfo.getWmmEnable();
        if (string == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        QosSetting qosSetting = this.getQosSetting();
        if (qosSetting == null) {
            qosSetting = new QosSetting();
        }
        Integer n2 = 0;
        if (string.equals("2.4GHz")) {
            qosSetting.setWmmEnable24(bl);
            if (bl.booleanValue()) {
                qosSetting.setApEdcaParams24(qosSettingInfo.getApEdcaParams());
                qosSetting.setDeliveryEnable24(qosSettingInfo.getDeliveryEnable());
                qosSetting.setNoAcknowledgement24(qosSettingInfo.getNoAcknowledgement());
                qosSetting.setStationEdcaParams24(qosSettingInfo.getStationEdcaParams());
            }
        } else {
            n2 = 1;
            if (string.equals("5GHz")) {
                qosSetting.setWmmEnable5(bl);
                if (bl.booleanValue()) {
                    qosSetting.setApEdcaParams5(qosSettingInfo.getApEdcaParams());
                    qosSetting.setDeliveryEnable5(qosSettingInfo.getDeliveryEnable());
                    qosSetting.setNoAcknowledgement5(qosSettingInfo.getNoAcknowledgement());
                    qosSetting.setStationEdcaParams5(qosSettingInfo.getStationEdcaParams());
                }
            } else {
                return new OperationResponse(ResErrorCode.d);
            }
        }
        if (!bl.booleanValue() && !(operationResponse = this.r.qosCheck(n2)).success()) {
            return operationResponse;
        }
        return this.saveQosSetting(qosSetting, n2, true);
    }

    @Override
    public void initRoamingSetting() {
        String string = com.tp_link.eap.d.b.a();
        RoamingSetting roamingSetting = new RoamingSetting();
        roamingSetting.setKey("roaming");
        roamingSetting.setFastRoaming(Integer.valueOf(0));
        roamingSetting.setDualBand11kReport(Integer.valueOf(0));
        roamingSetting.setForceDisassociation(Integer.valueOf(0));
        roamingSetting.setSite(string);
        com.tp_link.eap.d.b.g((String)string);
        this.w.save(roamingSetting);
    }

    @Override
    public RoamingSetting getRoamingSetting() {
        String string = com.tp_link.eap.d.b.a();
        String string2 = "roaming";
        return this.w.findByKeyAndSite(string2, string);
    }

    @Override
    public List<RoamingSetting> getRoamingSettingList() {
        String string = "roaming";
        return this.w.findByKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse modifyRoamingSetting(RoamingSetting roamingSetting) {
        if (null == roamingSetting) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = com.tp_link.eap.d.b.a();
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (!this.v.siteNameAlreadyExist(string)) {
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.r);
            }
            RoamingSetting roamingSetting2 = this.w.findByKeyAndSite("roaming", string);
            if (null == roamingSetting2) {
                b.warn("Roaming setting on site {} is null", (Object)string);
                roamingSetting2 = new RoamingSetting();
            }
            roamingSetting2.setFastRoaming(roamingSetting.getFastRoaming());
            roamingSetting2.setDualBand11kReport(roamingSetting.getDualBand11kReport());
            roamingSetting2.setForceDisassociation(roamingSetting.getForceDisassociation());
            this.w.save(roamingSetting2);
            IssuedRoamingInfo issuedRoamingInfo = new IssuedRoamingInfo();
            issuedRoamingInfo.setFastRoaming(roamingSetting2.getFastRoaming());
            issuedRoamingInfo.setDualBand11kReport(roamingSetting2.getDualBand11kReport());
            issuedRoamingInfo.setForceDisassociation(roamingSetting2.getForceDisassociation());
            this.l.refreshRecord("roaming", issuedRoamingInfo);
            com.tp_link.eap.d.b.g((String)string);
            return com.tp_link.eap.util.e.bd;
        }
    }

    @Override
    public OperationResponse getRestoreResult(ControlType controlType, JSONObject reqObj) {
        return new OperationResponse(ResErrorCode.a, (Object)com.tp_link.eap.util.restore.b.c());
    }

    @Override
    public OperationResponse getRoamingSetting(ControlType controlType, JSONObject reqObj) {
        return new OperationResponse(ResErrorCode.a, (Object)this.getRoamingSetting());
    }

    @Override
    public OperationResponse modifyRoamingSetting(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        if (jSONObject.containsKey((Object)"fastRoaming") && jSONObject.containsKey((Object)"dualBand11kReport") && jSONObject.containsKey((Object)"forceDisassociation")) {
            boolean bl = jSONObject.getBoolean("fastRoaming");
            boolean bl2 = jSONObject.getBoolean("dualBand11kReport");
            boolean bl3 = jSONObject.getBoolean("forceDisassociation");
            RoamingSetting roamingSetting = new RoamingSetting();
            roamingSetting.setFastRoaming(Integer.valueOf(bl ? 1 : 0));
            roamingSetting.setDualBand11kReport(Integer.valueOf(bl2 ? 1 : 0));
            roamingSetting.setForceDisassociation(Integer.valueOf(bl3 ? 1 : 0));
            return this.modifyRoamingSetting(roamingSetting);
        }
        return com.tp_link.eap.util.e.aZ;
    }

    @Override
    public OperationResponse getMeshSetting(ControlType controlType, JSONObject reqObj) {
        return new OperationResponse(ResErrorCode.a, (Object)this.getMeshSetting());
    }

    @Override
    public OperationResponse saveMeshSetting(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        if (jSONObject.containsKey((Object)"meshEnable")) {
            int n2;
            boolean bl = jSONObject.getBoolean("meshEnable");
            MeshSetting meshSetting = new MeshSetting();
            meshSetting.setMeshEnable(bl);
            if (jSONObject.containsKey((Object)"autoFailoverEnable")) {
                n2 = jSONObject.getBoolean("autoFailoverEnable");
                meshSetting.setAutoFailoverEnable(n2 != 0);
            }
            if (jSONObject.containsKey((Object)"defGatewayEnable")) {
                n2 = jSONObject.getInt("defGatewayEnable");
                meshSetting.setDefGatewayEnable(n2);
            }
            String string = "";
            if (jSONObject.containsKey((Object)"gateway")) {
                string = jSONObject.getString("gateway");
            }
            meshSetting.setGateway(string);
            return this.saveMeshSetting(meshSetting, true);
        }
        return com.tp_link.eap.util.e.aZ;
    }

    private boolean a(QosSettingInfo qosSettingInfo) {
        for (int i2 = 0; i2 < 16; i2 += 4) {
            List<Integer> list = qosSettingInfo.getApEdcaParams();
            List<Integer> list2 = qosSettingInfo.getStationEdcaParams();
            boolean bl = false;
            int n2 = 15;
            int n3 = 8192;
            if (list.get(i2) >= 0 && list.get(i2) <= 15 && list.get(i2 + 3) >= 0 && list.get(i2 + 3) <= 8192 && list.get(i2 + 3) % 32 == 0 && list2.get(i2) >= 0 && list2.get(i2) <= 15 && list2.get(i2 + 3) >= 0 && list2.get(i2 + 3) <= 8192 && list2.get(i2 + 3) % 32 == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public OperationResponse getHistoryRetention(ControlType controlType, JSONObject reqObj) {
        HistoryRetentionSetting historyRetentionSetting = this.getHistoryRetentionSetting();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"historyRetention", (Object)historyRetentionSetting.getRetention());
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
    }

    @Override
    public OperationResponse getLedStatus(ControlType controlType, JSONObject reqObj) {
        GlobalEnable globalEnable = this.getGlobalEnbale();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"ledOn", (Object)globalEnable.getLedOn());
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
    }

    @Override
    public OperationResponse getSSHInfo(ControlType controlType, JSONObject reqObj) {
        SshSetting sshSetting = this.getSshSetting();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"sshServerPort", (Object)sshSetting.getSshserverPort());
        jSONObject.put((Object)"sshEnable", (Object)sshSetting.getSshenable());
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
    }

    @Override
    public OperationResponse getVlanInfo(ControlType controlType, JSONObject reqObj) {
        ManagementVlanSetting managementVlanSetting = this.getManagementVlanSetting();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"managementVlanEnable", (Object)managementVlanSetting.getManagementVlanEnable());
        jSONObject.put((Object)"managementVlanId", (Object)managementVlanSetting.getManagementVlanId());
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setHistoryRetention(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.getInt("historyRetention");
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            HistoryRetentionSetting historyRetentionSetting = this.getHistoryRetentionSetting();
            if (historyRetentionSetting == null) {
                return new OperationResponse(ResErrorCode.i);
            }
            if (!n2.equals(historyRetentionSetting.getRetention())) {
                historyRetentionSetting.setRetention(n2);
                this.saveHistoryRetentionSetting(historyRetentionSetting);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setLedStatus(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Boolean bl = jSONObject.optBoolean("ledOn");
        if (bl == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.r);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (!this.v.siteNameAlreadyExist(string)) {
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.r);
            }
            GlobalEnable globalEnable = this.getGlobalEnbale();
            if (globalEnable == null) {
                return new OperationResponse(ResErrorCode.i);
            }
            if (!bl.equals(globalEnable.getLedOn())) {
                globalEnable.setLedOn(bl);
                this.saveGlobalEnable(globalEnable, "ledOn");
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setSSHInfo(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.optInt("sshServerPort");
        Boolean bl = jSONObject.optBoolean("sshEnable");
        if (n2 == null || bl == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.r);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (!this.v.siteNameAlreadyExist(string)) {
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.r);
            }
            SshSetting sshSetting = this.getSshSetting();
            if (sshSetting == null) {
                return new OperationResponse(ResErrorCode.i);
            }
            if (!n2.equals(sshSetting.getSshserverPort()) || !bl.equals(sshSetting.getSshenable())) {
                sshSetting.setSshenable(bl);
                sshSetting.setSshserverPort(n2);
                this.saveSshSetting(sshSetting, true);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setVlanInfo(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            b.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Boolean bl = jSONObject.optBoolean("managementVlanEnable");
        Integer n2 = jSONObject.optInt("managementVlanId");
        if (bl == null || n2 == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.r);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (!this.v.siteNameAlreadyExist(string)) {
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.r);
            }
            ManagementVlanSetting managementVlanSetting = this.getManagementVlanSetting();
            if (managementVlanSetting == null) {
                return new OperationResponse(ResErrorCode.i);
            }
            if (!bl.equals(managementVlanSetting.getManagementVlanEnable()) || !n2.equals(managementVlanSetting.getManagementVlanId())) {
                managementVlanSetting.setManagementVlanEnable(bl);
                managementVlanSetting.setManagementVlanId(n2);
                this.saveManagementVlanSetting(managementVlanSetting, true);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }
}

